/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org2.eclipse.php.internal.core.PHPVersion;
import org2.eclipse.php.internal.core.ast.match.ASTMatcher;
import org2.eclipse.php.internal.core.ast.nodes.AST;
import org2.eclipse.php.internal.core.ast.nodes.ASTNode;
import org2.eclipse.php.internal.core.ast.nodes.ChildPropertyDescriptor;
import org2.eclipse.php.internal.core.ast.nodes.Expression;
import org2.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org2.eclipse.php.internal.core.ast.visitor.Visitor;

public class ConditionalExpression
extends Expression {
    private Expression condition;
    private Expression ifTrue;
    private Expression ifFalse;
    public static final ChildPropertyDescriptor CONDITION_PROPERTY = new ChildPropertyDescriptor(ConditionalExpression.class, "condition", Expression.class, true, true);
    public static final ChildPropertyDescriptor IF_TRUE_PROPERTY = new ChildPropertyDescriptor(ConditionalExpression.class, "ifTrue", Expression.class, false, true);
    public static final ChildPropertyDescriptor IF_FALSE_PROPERTY = new ChildPropertyDescriptor(ConditionalExpression.class, "ifFalse", Expression.class, true, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<ChildPropertyDescriptor> list = new ArrayList<ChildPropertyDescriptor>(3);
        list.add(CONDITION_PROPERTY);
        list.add(IF_TRUE_PROPERTY);
        list.add(IF_FALSE_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(list);
    }

    public ConditionalExpression(AST ast) {
        super(ast);
    }

    public ConditionalExpression(int start, int end, AST ast, Expression condition, Expression ifTrue, Expression ifFalse) {
        super(start, end, ast);
        if (condition == null || ast.apiLevel().isLessThan(PHPVersion.PHP5_3) && ifTrue == null || ifFalse == null) {
            throw new IllegalArgumentException();
        }
        this.setCondition(condition);
        this.setIfTrue(ifTrue);
        this.setIfFalse(ifFalse);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        this.condition.accept(visitor);
        if (this.ifTrue != null) {
            this.ifTrue.accept(visitor);
        }
        this.ifFalse.accept(visitor);
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.condition.traverseTopDown(visitor);
        if (this.ifTrue != null) {
            this.ifTrue.traverseTopDown(visitor);
        }
        this.ifFalse.traverseTopDown(visitor);
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        this.condition.traverseBottomUp(visitor);
        this.ifTrue.traverseBottomUp(visitor);
        this.ifFalse.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<ConditionalExpression");
        this.appendInterval(buffer);
        buffer.append(">\n");
        buffer.append("\t").append(tab).append("<Condition>\n");
        this.condition.toString(buffer, "\t\t" + tab);
        buffer.append("\n").append("\t").append(tab).append("</Condition>\n");
        if (this.ifTrue != null) {
            buffer.append("\t").append(tab).append("<IfTrue>\n");
            this.ifTrue.toString(buffer, "\t\t" + tab);
            buffer.append("\n").append("\t").append(tab).append("</IfTrue>\n");
        }
        buffer.append("\t").append(tab).append("<IfFalse>\n");
        this.ifFalse.toString(buffer, "\t\t" + tab);
        buffer.append("\n").append("\t").append(tab).append("</IfFalse>\n");
        buffer.append(tab).append("</ConditionalExpression>");
    }

    @Override
    public int getType() {
        return 17;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public void setCondition(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.condition;
        this.preReplaceChild(oldChild, expression, CONDITION_PROPERTY);
        this.condition = expression;
        this.postReplaceChild(oldChild, expression, CONDITION_PROPERTY);
    }

    public Expression getIfTrue() {
        return this.ifTrue;
    }

    public void setIfTrue(Expression expression) {
        if (this.ast.apiLevel().isLessThan(PHPVersion.PHP5_3) && expression == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.ifTrue;
        this.preReplaceChild(oldChild, expression, IF_TRUE_PROPERTY);
        this.ifTrue = expression;
        this.postReplaceChild(oldChild, expression, IF_TRUE_PROPERTY);
    }

    public Expression getIfFalse() {
        return this.ifFalse;
    }

    public void setIfFalse(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.ifFalse;
        this.preReplaceChild(oldChild, expression, IF_FALSE_PROPERTY);
        this.ifFalse = expression;
        this.postReplaceChild(oldChild, expression, IF_FALSE_PROPERTY);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == CONDITION_PROPERTY) {
            if (get) {
                return this.getCondition();
            }
            this.setCondition((Expression)child);
            return null;
        }
        if (property == IF_TRUE_PROPERTY) {
            if (get) {
                return this.getIfTrue();
            }
            this.setIfTrue((Expression)child);
            return null;
        }
        if (property == IF_FALSE_PROPERTY) {
            if (get) {
                return this.getIfFalse();
            }
            this.setIfFalse((Expression)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    ASTNode clone0(AST target) {
        Expression condition = ASTNode.copySubtree(target, this.getCondition());
        Expression ifTrue = ASTNode.copySubtree(target, this.getIfTrue());
        Expression ifFalse = ASTNode.copySubtree(target, this.getIfTrue());
        ConditionalExpression result = new ConditionalExpression(this.getStart(), this.getEnd(), target, condition, ifTrue, ifFalse);
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }
}

